export interface CalendarDate {
  /**
   * The date (YYYY/MM/DD format). E.g. 2019/10/07.
   */
  date: string;
  /**
   * The shortened date (D MMM format). E.g. 7 Oct.
   */
  shortDate: string;
  /**
   * The day of the week (dddd format). E.g. Monday.
   */
  day: string;
  /**
   * The shortened day of the week (ddd format). E.g. Mon.
   */
  shortDay: string;
  /**
   * Whether that day is a weekend or not (Saturday or Sunday).
   */
  isWeekend: boolean;
  /**
   * Whether this date is today or not.
   */
  isToday: boolean;
}
