import { ReservationItem } from '../room/reservation-item';
import { CalendarIntersection } from './calendar-intersection';

export interface CalendarItem {
  /**
   * The id of the calendar item.
   */
  id: string;

  /**
   * The reservation item.
   */
  data: ReservationItem;

  /**
   * Where the item intersects the calendar.
   */
  intersection: CalendarIntersection;

  /**
   * Where the item intersects the extended calendar.
   */
  extendedIntersection: CalendarIntersection;

  /**
   * The id of the property that the item belongs to.
   */
  propertyId: string;

  /**
   * The id of the room that the item is allocated to.
   */
  roomId: string;

  /**
   * The currently persisted room id.
   */
  savedRoomId: string;

  /**
   * Whether this item has now been assigned to a room.
   */
  isRoomed: boolean;

  /**
   * Whether this item is locked or not.
   */
  isLocked: boolean;

  /**
   * Whether this item can be dragged or not.
   */
  canDrag: boolean;

  /**
   * The currently persisted status.
   */
  savedStatusInd: number;

  /**
   * The currently persisted status time.
   */
  savedStatusTime: string;

  /**
   * The currently persisted current status.
   */
  savedCurrentRoomStatusInd: number;

  /**
   * Whether a room was upgraded or not.
   */
  isUpgraded: boolean;

  /**
   * Whether the item is provisional or not.
   */
  isProvisional: boolean;

  /**
   * Whether this item can be checked in and out.
   */
  canCheckInOut: boolean;

  /**
   * Whether this item can be checked in.
   */
  canCheckIn: boolean;
}
