import { Room } from './room';
import { CalendarItem } from '../calendar/calendar-item';

export interface Conflict {
    /**
     * The date on which the conflict occurs.
     */
    date: string;

    /**
     * The id of the room in which the conflict occurs.
     */
    room: Room;

    /**
     * The items that are conflicting.
     */
    items: CalendarItem[];
}

export type ConflictsByDate = {[date: string]: Conflict[]};