import { Room } from './room';
import { Accommodation } from './accommodation';

/**
 * Represents a property to be rendered on the calendar.
 */
export interface Property {
  /**
   * The id of the property.
   */
  id: string;

  /**
   * The name of the property.
   */
  name: string;

  /**
   * The accommodation (types) that belong to the property.
   */
  accommodations: Accommodation[];

  /**
   * The rooms that belong to the property..
   */
  rooms: Room[];

  /**
   * Whether availability should be shown or not.
   */
  showAvailability: boolean;
}
