/**
 * A room that belongs to an accommodation.
 */
export interface Room {
  /**
   * The id of the room.
   */
  id: string;

  /**
   * The name or number of the room.
   */
  name: string;

  /**
   * The id of the accommodation that the room belongs to.
   */
  accommodationId: string;

  /**
   * The name of the accommodation that the room belongs to.
   */
  accommodationName: string;

  /**
   * Whether the room is for unallocated items.
   */
  forUnallocated: boolean;
}
