import { Component, OnInit, ChangeDetectionStrategy, ViewChild } from '@angular/core';
import { FilterService } from '../../services/filter/filter.service';
import { first } from 'rxjs/operators';
import { combineLatest } from 'rxjs';
import { AccommodationFilterComponent } from 'src/app/shared/components/accommodation-filter/accommodation-filter.component';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';

@Component({
  selector: 'app-more-filters',
  templateUrl: './more-filters.component.html',
  styleUrls: ['./more-filters.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class MoreFiltersComponent implements OnInit {
  properties$ = this.filterService.filterProperties$;
  selectedAccommodations$ = this.filterService.accommodations$;
  @ViewChild(AccommodationFilterComponent) propertyFilter: AccommodationFilterComponent;

  constructor(
    private filterService: FilterService,
    private sidebarService: SidebarService
  ) { }

  ngOnInit() {
  }

  close(): void {
    this.sidebarService.close();
  }

  apply(): void {
    combineLatest([this.filterService.accommodations$]).pipe(
      first()
    ).subscribe(([accommodations]) => {
      const currentAccommodations = this.propertyFilter.selectedAccommodations;

      if (this.accommodationsChanged(accommodations, currentAccommodations)) {
        this.filterService.onAccommodationsChanged([...currentAccommodations]);
      }
    });

    this.close();
  }

  private accommodationsChanged(original: string[], current: string[]): boolean {
    if (original.length !== current.length) {
      return true;
    }

    const originalClone = [...original];
    originalClone.sort();
    const currentClone = [...current];
    currentClone.sort();

    for (let i = 0; i < originalClone.length; i++) {
      if (originalClone[i] !== currentClone[i]) {
        return true;
      }
    }

    return false;
  }
}
