import { Component, OnInit, Input, OnDestroy } from '@angular/core';
import { ReservationContacts } from '../../core/reservation/reservation-contacts';
import { Observable, combineLatest } from 'rxjs';
import { ReservationService } from '../../services/reservation/reservation.service';
import { CalendarService } from '../../services/calendar/calendar.service';
import { switchMap, map, filter, skip } from 'rxjs/operators';
import { ReservationPortalService } from '../../services/reservation-portal/reservation-portal.service';
import { PortalService } from 'src/app/shared/components/portal';
import { SubSink } from 'subsink';

@Component({
  selector: 'app-reservation-contacts',
  templateUrl: './reservation-contacts.component.html',
  styleUrls: ['./reservation-contacts.component.scss']
})
export class ReservationContactsComponent implements OnInit, OnDestroy {
  @Input() portalName: string;
  contacts$: Observable<ReservationContacts>;
  private subsink: SubSink;

  constructor(
    private calendarService: CalendarService,
    private reservationService: ReservationService,
    private reservationPortalService: ReservationPortalService,
    private portalService: PortalService
  ) {
    this.subsink = new SubSink();
  }

  ngOnInit(): void {
    this.contacts$ = combineLatest(
      this.calendarService.activeItem$,
      this.reservationPortalService.refresh$
    ).pipe(
      map(([activeItem]) => activeItem),
      switchMap(item => this.reservationService.getContacts(item.data.reservationId))
    );

    this.subsink.sink = this.reservationPortalService.refresh$.pipe(
      switchMap(() => this.portalService.activePortal$),
      filter(activePortal => activePortal.name === this.portalName),
      switchMap(() => {
        this.portalService.onShowLoading(true);
        return this.contacts$
      })
    ).subscribe(() => {
      this.portalService.onShowLoading(false);
    })
  }

  ngOnDestroy() {
    this.subsink.unsubscribe();
  }
}
