import { Component, OnInit, Input } from '@angular/core';
import { RoomGroup } from 'src/app/rooming-calendar/core/reservation/room-group';

@Component({
  selector: 'app-itinerary-room-group',
  templateUrl: './itinerary-room-group.component.html',
  styleUrls: ['./itinerary-room-group.component.scss']
})
export class ItineraryRoomGroupComponent implements OnInit {
  @Input() group: RoomGroup;
  @Input() index: number;
  header: string;
  upgradeText: string;
  rooms: number[];
  guestNames: string[];

  constructor() {
    this.rooms = [];
    this.upgradeText = '';
  }

  ngOnInit(): void {
    if (this.group.roomAllocation) {
      const roomAllocation = this.group.roomAllocation;

      if (roomAllocation.upgraded) {
        this.upgradeText = `Upgrade from ${roomAllocation.upgradeFromName}`;
      }

      this.header = `${roomAllocation.accommName} - ${roomAllocation.roomName}`;
    } else {
      this.header = 'Unallocated room';
    }

    const roomCount = Math.max(this.group.roomAllocation.capacity, this.group.guests.length);

    for (let i = 0; i < roomCount; i++) {
      this.rooms.push(i);
    }

    this.guestNames = this.group.guests.map(guest => {
      return guest.firstName + ' ' + guest.lastName;
    });
  }
}
