import { Component, Input, OnChanges, SimpleChanges, ViewChild, AfterViewInit } from '@angular/core';
import { Itinerary } from 'src/app/rooming-calendar/core/reservation/itinerary';
import { MatExpansionPanel } from '@angular/material/expansion';

@Component({
  selector: 'app-itinerary',
  templateUrl: './itinerary.component.html',
  styleUrls: ['./itinerary.component.scss']
})
export class ItineraryComponent implements AfterViewInit, OnChanges {
  @Input() itinerary: Itinerary;
  @Input() showDetailedRooming: boolean;
  @Input() showExtras: boolean;
  @Input() lastItinerary: boolean;
  expanded: boolean;
  @ViewChild('expansionPanel') expansionPanel: MatExpansionPanel;

  constructor() {
    this.expanded = false;
    this.showDetailedRooming = false;
    this.showExtras = false;
  }

  ngAfterViewInit() {
    if (this.showDetailedRooming || this.showExtras) {
      setTimeout(() => {
        this.expanded = true;
        this.expansionPanel.open();
      });
    }
  }

  toggleExpansion(): void {
    this.expanded = !this.expanded;
  }

  ngOnChanges(changes: SimpleChanges) {
    for (let propName in changes) {
      const observe = ['showDetailedRooming', 'showExtras'];

      if (observe.includes(propName)) {
        const change = changes[propName];

        if (change.currentValue) {
          // One of the toggles was toggled on
          this.expanded = true;

          if (this.expansionPanel) {
            this.expansionPanel.open();
          }
        }
      }
    }
  }
}
