import { Component, OnInit, Input, ViewChild, ElementRef } from '@angular/core';
import { MatExpansionPanel } from '@angular/material/expansion';

@Component({
  selector: 'app-note',
  templateUrl: './note.component.html',
  styleUrls: ['./note.component.scss']
})
export class NoteComponent implements OnInit {
  @Input() heading: string;
  @Input() note: string;
  @Input() expanded: boolean;
  @ViewChild('panel') panel: MatExpansionPanel;

  private fullyExpandInternal = false;

  get fullyExpand(): boolean {
    return this.fullyExpandInternal;
  }

  @Input() set fullyExpand(expand: boolean) {
    this.fullyExpandInternal = expand;

    if (this.panel) {
      this.panel.open();
    }
  }

  @Input() maxHeight: number;
  contentExpanded: boolean;
  overflowedContent: boolean;

  @ViewChild('content') set content(elem: ElementRef) {
    setTimeout(() => this.measure(elem.nativeElement));
  }

  constructor() {
    this.heading = '';
    this.note = '';
    this.expanded = false;
    this.fullyExpand = false;
    this.contentExpanded = false;
    this.overflowedContent = true;
    this.maxHeight = 100;     // 100px max height
  }

  ngOnInit(): void {
  }

  toggleExpansion(): void {
    this.contentExpanded = !this.contentExpanded;
  }

  /**
   * Check whether the content is greater than the max height that was set for it.
   */
  private measure(elem: any): void {
    this.overflowedContent = elem.scrollHeight > this.maxHeight;
  }
}
