import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { RoomingCalendarComponent } from './rooming-calendar.component';
import { MatButtonModule } from '@angular/material/button';
import { FiltersComponent } from './filters/filters.component';
import { MatIconModule } from '@angular/material/icon';
import { MatSelectModule } from '@angular/material/select';
import { MatMomentDateModule } from '@angular/material-moment-adapter';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { FormsModule } from '@angular/forms';
import { FilterHeaderComponent } from './filters/filter-header/filter-header.component';
import { MoreFiltersComponent } from './filters/more-filters/more-filters.component';
import { MatDividerModule } from '@angular/material/divider';
import { CalendarComponent } from './calendar/calendar.component';
import { SearchHeaderComponent } from './calendar/search-header/search-header.component';
import { NavigatePreviousComponent } from './calendar/navigate-previous/navigate-previous.component';
import { NavigateNextComponent } from './calendar/navigate-next/navigate-next.component';
import { DateHeaderComponent } from './calendar/date-header/date-header.component';
import { FontAwesomeModule, FaIconLibrary } from '@fortawesome/angular-fontawesome';
import {
  fas,
  faAngleDoubleLeft,
  faAngleDoubleRight,
  faAngleLeft,
  faAngleRight,
  faFilter,
  faInfoCircle,
  faLock,
  faUnlock
} from '@fortawesome/free-solid-svg-icons';
import { RoomHeaderComponent } from './calendar/room-header/room-header.component';
import { DateCellComponent } from './calendar/date-cell/date-cell.component';
import { ReservationItemComponent } from './calendar/reservation-item/reservation-item.component';
import { DragDropModule } from '@angular/cdk/drag-drop';
import { CalendarHeaderComponent } from './calendar/calendar-header/calendar-header.component';
import { PropertyComponent } from './calendar/property/property.component';
import { FilterService } from './services/filter/filter.service';
import { RoomService } from './services/room/room.service';
import { CalendarService } from './services/calendar/calendar.service';
import { ResrequestCommonModule } from 'resrequest-angular-common';
import { BlockItemComponent } from './calendar/block-item/block-item.component';
import { SharedModule } from '../shared/shared.module';
import { ReservationPortalComponent } from './reservation/reservation-portal/reservation-portal.component';
import { ReservationNotesComponent } from './reservation/reservation-notes/reservation-notes.component';
import { MatInputModule } from '@angular/material/input';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatSidenavModule } from '@angular/material/sidenav';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatExpansionModule } from '@angular/material/expansion';
import { RoomingCalendarRoutingModule } from './rooming-calendar-routing.module';
import { MatMenuModule } from '@angular/material/menu';
import { MatTooltipModule } from '@angular/material/tooltip';
import { FilterPortalComponent } from './filters/filter-portal/filter-portal.component';
import { SettingsService } from './services/settings/settings.service';
import { PropInfoSidenavComponent } from './calendar/prop-info-sidenav/prop-info-sidenav.component';
import { MapComponent } from './calendar/prop-info-sidenav/map/map.component';
import { NoteComponent } from './reservation/reservation-notes/note/note.component';
import { ContactDetailComponent } from './reservation/reservation-contacts/contact-detail/contact-detail.component';
import { ReservationContactsComponent } from './reservation/reservation-contacts/reservation-contacts.component';
import { ReservationService } from './services/reservation/reservation.service';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { ReservationItineraryComponent } from './reservation/reservation-itinerary/reservation-itinerary.component';
import { ItineraryComponent } from './reservation/reservation-itinerary/itinerary/itinerary.component';
import { ItineraryDateHeaderComponent } from './reservation/reservation-itinerary/itinerary/itinerary-date-header/itinerary-date-header.component';
import { ItineraryRoomingSummaryComponent } from './reservation/reservation-itinerary/itinerary/itinerary-rooming-summary/itinerary-rooming-summary.component';
import { ItineraryRoomingDetailedComponent } from './reservation/reservation-itinerary/itinerary/itinerary-rooming-detailed/itinerary-rooming-detailed.component';
import { ItineraryHeaderComponent } from './reservation/reservation-itinerary/itinerary/itinerary-header/itinerary-header.component';
import { ItineraryRoomGroupComponent } from './reservation/reservation-itinerary/itinerary/itinerary-room-group/itinerary-room-group.component';
import { ItineraryExtraComponent } from './reservation/reservation-itinerary/itinerary/itinerary-extra/itinerary-extra.component';
import { ItineraryExtraHeaderComponent } from './reservation/reservation-itinerary/itinerary/itinerary-extra-header/itinerary-extra-header.component';
import { PropInfoService } from './services/prop-info/prop-info.service';
import { ReservationPortalService } from './services/reservation-portal/reservation-portal.service';
import { ReportService } from './services/report/report.service';
import { PropInfoSidenavContainerComponent } from './calendar/prop-info-sidenav-container/prop-info-sidenav-container.component';
import { HotkeysComponent } from './calendar/hotkeys/hotkeys.component';
import { ConfigOptionsComponent } from './filters/config-options/config-options.component';
import { GuestPipe } from './calendar/reservation-item/guest.pipe';
import { ReservationCheckInComponent } from './reservation/reservation-check-in/reservation-check-in.component';
import { ReservationAddExtrasComponent } from './reservation/reservation-add-extras/reservation-add-extras.component';
import { ReservationManageBillingComponent } from './reservation/reservation-manage-billing/reservation-manage-billing.component';
import { WindowService } from './services/window/window.service';
import { ConflictInfoComponent } from './calendar/conflict-info/conflict-info.component';
import { MatBadgeModule } from '@angular/material/badge';
import { CalendarAccessService } from './services/access/calendar-access.service';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { BulkCheckInOutComponent } from './bulk/bulk-check-in-out/bulk-check-in-out.component';
import { BulkPortalComponent } from './bulk/bulk-portal/bulk-portal.component';
import { ScrollingModule } from '@angular/cdk/scrolling';

@NgModule({
  declarations: [
    RoomingCalendarComponent,
    FiltersComponent,
    FilterHeaderComponent,
    MoreFiltersComponent,
    CalendarComponent,
    SearchHeaderComponent,
    NavigatePreviousComponent,
    NavigateNextComponent,
    DateHeaderComponent,
    RoomHeaderComponent,
    DateCellComponent,
    ReservationItemComponent,
    CalendarHeaderComponent,
    PropertyComponent,
    BlockItemComponent,
    ReservationPortalComponent,
    ReservationNotesComponent,
    ReservationCheckInComponent,
    ReservationAddExtrasComponent,
    ReservationManageBillingComponent,
    FilterPortalComponent,
    PropInfoSidenavComponent,
    MapComponent,
    PropInfoSidenavContainerComponent,
    HotkeysComponent,
    ConfigOptionsComponent,
    ContactDetailComponent,
    ReservationContactsComponent,
    NoteComponent,
    ReservationItineraryComponent,
    ItineraryComponent,
    ItineraryDateHeaderComponent,
    ItineraryRoomingSummaryComponent,
    ItineraryRoomingDetailedComponent,
    ItineraryHeaderComponent,
    ItineraryRoomGroupComponent,
    ItineraryExtraComponent,
    ItineraryExtraHeaderComponent,
    GuestPipe,
    ConflictInfoComponent,
    BulkCheckInOutComponent,
    BulkPortalComponent
  ],
  imports: [
    CommonModule,
    RoomingCalendarRoutingModule,
    MatButtonModule,
    MatIconModule,
    MatSelectModule,
    MatInputModule,
    MatMomentDateModule,
    MatDatepickerModule,
    FormsModule,
    MatDividerModule,
    FontAwesomeModule,
    DragDropModule,
    MatButtonToggleModule,
    MatSidenavModule,
    MatCheckboxModule,
    ResrequestCommonModule,
    SharedModule,
    MatExpansionModule,
    MatMenuModule,
    MatSlideToggleModule,
    MatTooltipModule,
    MatBadgeModule,
    MatProgressSpinnerModule,
    ScrollingModule
  ],
  exports: [
    RoomingCalendarComponent,
    ReservationNotesComponent
  ],
  providers: [
    FilterService,
    RoomService,
    CalendarService,
    SettingsService,
    ReservationService,
    PropInfoService,
    ReservationPortalService,
    ReportService,
    WindowService,
    CalendarAccessService
  ]
})
export class RoomingCalendarModule {
  constructor(library: FaIconLibrary) {
    library.addIconPacks(fas);
    library.addIcons(
      faAngleDoubleLeft,
      faAngleDoubleRight,
      faAngleLeft,
      faAngleRight,
      faFilter,
      faInfoCircle,
      faLock,
      faUnlock
    );
  }
}
