import { Injectable } from '@angular/core';
import { AuthorisationService } from 'src/app/shared/services/authorisation/authorisation.service';
import { Observable, BehaviorSubject } from 'rxjs';
import { filter, first } from 'rxjs/operators';

const ROOMING_CALENDAR_FUNCTION = 81;
const EDIT_RES_TABS_FUNCTION = 52;

@Injectable()
export class CalendarAccessService {
  private canUpdateSource: BehaviorSubject<boolean>;
  canUpdate$: Observable<boolean>;
  private canDateCheckoutsSource: BehaviorSubject<boolean>;
  canDateCheckouts$: Observable<boolean>;
  canEditResTabs: boolean;

  constructor(private authorisation: AuthorisationService) {
    this.canUpdateSource = new BehaviorSubject<boolean>(false);
    this.canUpdate$ = this.canUpdateSource.asObservable();
    this.canDateCheckoutsSource = new BehaviorSubject<boolean>(false);
    this.canDateCheckouts$ = this.canDateCheckoutsSource.asObservable();

    this.updateAccess();
  }

  private updateAccess(): void {
    this.authorisation.accessLoaded$.pipe(
      filter(loaded => loaded),
      first()
    ).subscribe(() => {
      const canUpdate = this.authorisation.functionAccessLevel(ROOMING_CALENDAR_FUNCTION) >= 10;
      this.canUpdateSource.next(canUpdate);
      const canDateCheckouts = this.authorisation.functionAccessLevel(ROOMING_CALENDAR_FUNCTION) >= 15;
      this.canDateCheckoutsSource.next(canDateCheckouts);
      this.canEditResTabs = this.authorisation.functionAccessLevel(EDIT_RES_TABS_FUNCTION) >= 10 ? true : false;
    });
  }
}
