import { Injectable, NgZone } from '@angular/core';
import { RcmApiService } from 'resrequest-angular-common';
import { RoomService } from '../room/room.service';
import { Observable, BehaviorSubject } from 'rxjs';
import { skip } from 'rxjs/operators';
import { WindowService } from '../window/window.service';

@Injectable()
export class LegacyService {
  private loadingSource: BehaviorSubject<boolean>;
  loading$: Observable<boolean>;

  constructor(
    public api: RcmApiService,
    private ngZone: NgZone,
    private roomService: RoomService,
    private windowService: WindowService
  ) {
    (window as any)['ng_rooming_legacy_change_room'] = (action, reservationId, groupId, roomId, resItemId, requestYn, requestReason) => {
      this.ngZone.run(() => {
        this.changeRoomApply(action, {
          reservation_id: reservationId,
          id: groupId,
          room_id: roomId,
          parent_id: resItemId,
          request_yn: requestYn,
          request_reason: requestReason
        });
      });
    };

    (window as any)['ng_rooming_legacy_add_guests'] = (resId, resItemId, groupId) => {
      this.ngZone.run(() => {
        this.manageGuestsApply(resId, resItemId, groupId);
      });
    };

    (window as any)['ng_rooming_legacy_add_extras'] = (resItemId) => {
      this.ngZone.run(() => {
        this.addExtrasApply(resItemId);
      });
    };

    (window as any)['ng_rooming_legacy_financials'] = (action, target) => {
      this.ngZone.run(() => {
        this.financialsApply(action, target);
      });
    };

    (window as any)['ng_rooming_legacy_deposit_page'] = (resId, autoFind) => {
      this.ngZone.run(() => {
        location.href = `/reservation.php?1021++${resId}+${autoFind}`;
      });
    };

    this.loadingSource = new BehaviorSubject(false);
    this.loading$ = this.loadingSource.asObservable();
  }

  paxReport(reportType, accommIds, startDate, endDate?) {
    let finalDate = '';
    if(reportType === 'range') {
      finalDate = endDate.clone().subtract(1, 'days').format('YYYY-MM-DD');
    }
    this.windowService.openLegacyPopup('737'
      /*  1 */ + '+'
      /*  2 */ + '+' + startDate.format('YYYY-MM-DD')
      /*  3 */ + '+' + finalDate
      /*  4 */ + '+'
      /*  5 */ + '+'
      /*  6 */ + '+' + reportType
      /*  7 */ + '+'
      /*  8 */ + '+'
      /*  9 */ + '+' // nationality ids
      /* 10 */ + '+' // render option
      /* 11 */ + '+1' // confirmed
      /* 12 */ + '+1' // provisional
      /* 13 */ + '+' // source ids
      /* 14 */ + '+' // random id
      /* 15 */ + '+'
      /* 16 */ + '+' + accommIds,
    'pax_report', 695, 344);
  }

  daySheet(propertyId, date) {
    this.windowService.openLegacyPopup('741'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD')
      /* 3 */ + '+',
    'day_sheet', 715, 500);
  }

  extrasReport(propertyId, date) {
    this.windowService.openLegacyPopup('739'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD'),
    'extras_report', 600, 450);
  }

  foliosReport(reportType, propertyId, date) {
    this.windowService.openLegacyPopup('740'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD')
      /* 3 */ + '+'
      /* 4 */ + '+'
      /* 5 */ + '+' + reportType,
    reportType + '_folios_report', 715, 450);
  }

  roomFunctions(item) {
    this.windowService.openLegacyPopup('224'
      /* rv_res_item_group_id   */ + '+' + item.id
      /* ac_accomm_room_id      */ + '+' + item.roomId
      /* rv_reservation_item_id */ + '+' + item.parentId
      /* method                 */ + '+upgrade',
    'change_room', 475, 720);
  }

  /*
    action = change|checkin
    params:
      id: Room group id (may be empty)
      room_id: The roomService to put the guest into
      parent_id: Itinerary id
      request_yn: true or false
      request_reason: text
  */
  async changeRoomApply(action, params) {
    this.onLoadingChange(true);

    const postParams = {
      reservation_item_id: params.parent_id,
      res_item_group_id: params.id,
      room_id: params.room_id,
      requested_yn: params.request_yn,
      requested_reason: params.request_reason
    };

    if (action === 'checkin') {
      const key = 'status_ind';
      postParams[key] = '5';
    }

    await this.api.post('/api/v1/rooming/set_item', postParams).toPromise();
    this.roomService.refresh();

    // Wait for calendar to finish refreshing
    await this.roomService.items$.pipe(skip(1)).toPromise();
    this.onLoadingChange(false);
  }

  addGuests(item) {
    this.windowService.openLegacyPopup('242'
      /* rv_res_item_group_id   */ + '+' + item.id
      /* rv_reservation_item_id */ + '+' + item.parentId,
    'add_guests', 1040, 600);
  }

  manageGuestsApply(resId, resItemId, groupId) {
    this.onLoadingChange(true);
    const items = this.roomService.itemsByReservationItemId(resItemId);
    this.roomService.refreshItems(items).then(() => {
      this.onLoadingChange(false);
    });
  }

  addExtras(item) {
    this.windowService.openLegacyPopup('243'
      /* rv_res_item_group_id      */ + '+' + item.id
      /* rv_reservation_item_id    */ + '+' + item.parentId
      /* rv_reservation_id         */ + '+' + item.reservationId
      /* pr_business_id (property) */ + '+:',
    'add_extras', 1215, 600);
  }

  addExtrasApply(resItemId: string) {
    if (resItemId) {
      // Update and pay was clicked.
      this.openPayment(resItemId);
    }
  }

  openPayment(resItemId: string): void {
    this.windowService.openLegacyPopup('244'
      /* rv_res_item_group_id      */ + '+' + ''
      /* room id                   */ + '+' + ''
      /* rv_reservation_item_id    */ + '+' + resItemId,
    'open_payment', 1025, 530);
  }

  manageBilling(item) {
    this.windowService.openLegacyPopup('244'
      /* rv_res_item_group_id    */ + '+' + item.id
      /* ac_accomm_room_id      */ + '+' + item.roomId
      /* rv_reservation_item_id */ + '+' + item.parentId,
    'financials', 750, 400);
  }

  financialsApply(action, target) {
    switch (action) {
      case 'deposit': {
        const url = '/reservation.php?1021';
        document.location.href = url + '++' + target + '+1';
        break;
      }
      case 'checkout': {
        // This action is specified in room_pay_folio.htm but
        // not invoked anywhere
        break;
      }
      default: {
        break;
      }
    }
  }

  auditTrail(item) {
    this.windowService.openLegacyPopup('700'
      /* rv_reservation_id */ + '+' + item.reservationId,
    'audit_trail', 1080, 600);
  }

  onLoadingChange(loading: boolean) {
    this.loadingSource.next(loading);
  }

  guestDetails(groupId, guestId) {
    this.windowService.openLegacyPopup('212' + '+' + guestId + '++++1', 'Guest Details', 1190, 700);

    (window as any)['ng_rooming_legacy_guest_pop'] = () => {
      this.ngZone.run(() => {
        this.guestDetailsApply(groupId, guestId);
      });
    };
  }

  guestDetailsApply(groupId, guestId) {
    this.onLoadingChange(true);
    const item = this.roomService.itemByGroupId(groupId);
    this.roomService.refreshItems([item]).then(() => {
      this.onLoadingChange(false);
    });
  }
}
