import { Injectable } from '@angular/core';
import { RcmApiService } from 'resrequest-angular-common';

@Injectable()
export class PropInfoService {

  constructor(private api: RcmApiService) { }

  public getPropInfo(id: string, isProp: boolean): any {
    var request:any = {
      "prNameLast": "*",
      "prBusMemoCalYn": true,
      "prBusMemoInfoYn": true,
      "prBusinessGpsCoordsYn": true,
      "prBusinessSocialLinksYn": true,
      "prBusinessImagesYn": true,
      "prWebAddrYn": true,
      "acAccommDesc": "*",
      "acAccommNoteYn": true,
      "acAccommMaxCapacityYn": true,
      "acAccommMaxAdultsYn": true,
      "acAccommMaxChildAgeYn": true,
      "acAccommCapacityYn": true,
      "acAccommImagesYn": true
    };

    if (isProp) {
      request.prBusinessId = [ id ];
    } else {
      request.acAccommTypeIx = [ id ];
    }
    return this.api.post('/api/v1/business_structure/get_properties', request);
  }
}
