import { Injectable } from '@angular/core';
import * as moment from 'moment';
import { WindowService } from '../window/window.service';

@Injectable()
export class ReportService {

  constructor(private windowService: WindowService) {}

   daySheet(propertyId: string, date: moment.Moment) {
    this.windowService.openLegacyPopup('741'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD')
      /* 3 */ + '+',
    'day_sheet', 1000, 600);
  }

   paxReport(reportType: string, accommIds: string[], startDate: moment.Moment, endDate?: moment.Moment) {
    let finalDate = '';
    if (reportType === 'range') {
      finalDate = endDate.clone().subtract(1, 'days').format('YYYY-MM-DD');
    }
    this.windowService.openLegacyPopup('737'
      /*  1 */ + '+'
      /*  2 */ + '+' + startDate.format('YYYY-MM-DD')
      /*  3 */ + '+' + finalDate
      /*  4 */ + '+'
      /*  5 */ + '+'
      /*  6 */ + '+' + reportType
      /*  7 */ + '+'
      /*  8 */ + '+'
      /*  9 */ + '+' // nationality ids
      /* 10 */ + '+' // render option
      /* 11 */ + '+1' // confirmed
      /* 12 */ + '+1' // provisional
      /* 13 */ + '+' // source ids
      /* 14 */ + '+' // random id
      /* 15 */ + '+'
      /* 16 */ + '+' + accommIds.join(':'),
    'pax_report', 1000, 600);
  }

  extrasReport(propertyId: string, date: moment.Moment) {
    this.windowService.openLegacyPopup('739'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD'),
    'extras_report', 1000, 600);
  }

  foliosReport(reportType: string, propertyId: string, date: moment.Moment) {
    this.windowService.openLegacyPopup('740'
      /* 1 */ + '+' + propertyId
      /* 2 */ + '+' + date.format('YYYY-MM-DD')
      /* 3 */ + '+'
      /* 4 */ + '+'
      /* 5 */ + '+' + reportType,
    reportType + '_folios_report', 1000, 600);
  }
}
