import { Injectable } from '@angular/core';
import { Observable, BehaviorSubject } from 'rxjs';

@Injectable()
export class ReservationPortalService {
  private refreshSource: BehaviorSubject<null>;
  refresh$: Observable<void>;
  private openPortalSource: BehaviorSubject<string>;
  openPortal$: Observable<string>;

  constructor() {
    this.refreshSource = new BehaviorSubject<null>(null);
    this.refresh$ = this.refreshSource.asObservable();
    this.openPortalSource = new BehaviorSubject<string>('');
    this.openPortal$ = this.openPortalSource.asObservable();
  }

  refresh() {
    this.refreshSource.next(null);
  }

  onOpenPortal(portal: string): void {
    this.openPortalSource.next(portal);
  }
}
