import { Injectable } from '@angular/core';

@Injectable()
export class WindowService {
  private openedWindows: Window[];

  constructor() {
    this.openedWindows = [];
    window.addEventListener('beforeunload', e => this.closeWindows(e));
  }

  closeWindows(e) {
    for (let w of this.openedWindows) {
      w.close();
    }
  }

  openLegacyPopup(url: string, name?: string, width?: number, height?: number): void {
    const legacyUrl = 'reservation.php?' + url;
    this.openPopup(legacyUrl, name, width, height);
  }

  openPopup(url: string, name?: string, w?: number, h?: number): void {
    if (!name) { name = ''; }
    if (!w) { w = 400; }
    if (!h) { h = 300; }

    const dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screenLeft;

    const windowWidth = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const windowHeight = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
    
    var systemZoom = windowWidth / window.screen.availWidth;

    const x = ((windowWidth / 2) - (w / 2))/ systemZoom + dualScreenLeft; // X co-ord to center screen horizontally
    const y = ((windowHeight - h)/2); // X co-ord to center screen virtically

    const size = 'fullscreen=0,width=' + w + ',height=' + h + ',left=' + x + ',top=' + y;

    const windowRef = window.open(url, name, size);

    this.openedWindows.push(windowRef);
  }
}
