import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import * as moment from 'moment';

@Component({
  selector: 'app-date-input',
  templateUrl: './date-input.component.html',
  styleUrls: ['./date-input.component.scss']
})
export class DateInputComponent implements OnInit {
  @Input() date: moment.Moment;
  @Input() backgroundColour: string;
  @Output() dateChange: EventEmitter<moment.Moment>;

  constructor() {
    this.date = moment();
    this.dateChange = new EventEmitter<moment.Moment>();
    this.backgroundColour = '#fff';
  }

  ngOnInit(): void {
  }

  onDateChange(): void {
    this.dateChange.emit(this.date.clone());
  }
}
