import { Directive, Input, TemplateRef, OnInit } from '@angular/core';
import { PortalService } from './portal.service';
import { Portal } from './portal.model';

@Directive({
  selector: '[appPortalContent]'
})
export class PortalContentDirective implements OnInit {
  @Input('appPortalContent') name: string;
  @Input('appPortalContentHeading') heading: string;
  @Input('appPortalContentCustomHeader') customHeader: TemplateRef<any>;

  constructor(
    private template: TemplateRef<any>,
    private portalService: PortalService
  ) {
  }

  ngOnInit() {
    const portal: Portal = {
      name: this.name,
      heading: this.heading,
      customHeader: this.customHeader,
      template: this.template
    };
    this.portalService.addPortal(portal);
  }
}
