import { Component, OnInit, OnDestroy, Input } from '@angular/core';
import { PortalService } from '../portal.service';
import { SubSink } from 'subsink';

@Component({
  selector: 'app-portal-header',
  templateUrl: './portal-header.component.html',
  styleUrls: ['./portal-header.component.scss']
})
export class PortalHeaderComponent implements OnInit, OnDestroy {
  private showMenu: boolean;
  private subsink: SubSink;
  activePortal$ = this.portal.activePortal$;
  showLoading$ = this.portal.showLoading$;
  @Input() enableMenu: boolean;

  constructor(private portal: PortalService) {
    this.subsink = new SubSink();
    this.enableMenu = true;
  }

  ngOnInit() {
    this.subsink.sink = this.portal.showMenu$.subscribe(showMenu => {
      this.showMenu = showMenu;
    });
  }

  ngOnDestroy() {
    this.subsink.unsubscribe();
  }

  toggleMenu() {
    this.portal.onShowMenuChanged(!this.showMenu);
  }

  closePortal() {
    this.portal.onClose();
  }
}
