import { Component, Input, HostListener, HostBinding, OnDestroy } from '@angular/core';
import { PortalService } from '../portal.service';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';
import { SubSink } from 'subsink';

@Component({
  selector: 'app-portal-menu-item',
  templateUrl: './portal-menu-item.component.html',
  styleUrls: ['./portal-menu-item.component.scss']
})
export class PortalMenuItemComponent implements OnDestroy {
  @Input() text: string;
  @Input() contentPortal: string;
  @Input() action: string;
  @Input() highlighOnPortalActive: boolean;
  @HostBinding('class.disabled') @Input() disabled: boolean;
  active$: Observable<boolean>;
  @HostBinding('class.active') active: boolean;
  private subsink: SubSink;

  constructor(private portalService: PortalService) {
    this.text = '';
    this.contentPortal = '';
    this.action = '';
    this.highlighOnPortalActive = true;
    this.disabled = false;
    this.active = false;
    this.subsink = new SubSink();
    this.subsink.sink = portalService.activePortal$.pipe(
      map(activePortal => {
        if (!activePortal) {
          return false;
        }

        if (
          this.highlighOnPortalActive
          && activePortal.name === this.contentPortal
        ) {
          return true;
        } else {
          return false;
        }
      }),
    ).subscribe(active => this.active = active);
  }

  ngOnDestroy() {
    this.subsink.unsubscribe();
  }

  @HostListener('click')
  onClick(): void {
    if (!this.disabled && !this.active) {
      if (this.action) {
        this.portalService.onActionClicked(this.action);
      }

      if (this.contentPortal) {
        this.portalService.onPortalSelected(this.contentPortal);
      }
    }
  }
}
