import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { User } from './user';
import { RcmApiService } from 'resrequest-angular-common';

@Injectable()
export class InfoService {
  /**
   * The source for user$.
   */
  private userSource: BehaviorSubject<User|null>;

  /**
   * The currently logged in user.
   */
  user$: Observable<User|null>;

  /**
   * The source for environment$.
   */
  private environmentSource: BehaviorSubject<string|null>;

  /**
   * The current environment.
   */
  environment$: Observable<string|null>;

  /**
   * The source for client$.
   */
  private clientSource: BehaviorSubject<string|null>;

  /**
   * The current client/principal short name.
   */
  client$: Observable<string|null>;

  /**
   * The source for principalName$.
   */
  private principalNameSource: BehaviorSubject<string|null>;

  /**
   * The current client/principal name.
   */
  principalName$: Observable<string|null>;

  constructor(private api: RcmApiService) {
    this.userSource = new BehaviorSubject<User|null>(null);
    this.user$ = this.userSource.asObservable();
    this.environmentSource = new BehaviorSubject<string|null>(null);
    this.environment$ = this.environmentSource.asObservable();
    this.clientSource = new BehaviorSubject<string|null>(null);
    this.client$ = this.clientSource.asObservable();
    this.principalNameSource = new BehaviorSubject<string|null>(null);
    this.principalName$ = this.principalNameSource.asObservable();
    this.fetchInfo();
  }

  private fetchInfo(): void {
    this.api.post('/api/v1/ping', {}).subscribe(data => {
      const user = {
        username: data.user.username,
        userId: data.user.user_id,
        name: data.user.name,
        statusId: data.user.status_id
      };
      this.userSource.next(user);
      this.environmentSource.next(data.environment);
      this.clientSource.next(data.client);
      this.principalNameSource.next(data.principalName);
    });
  }
}
