import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { PortalComponent } from './components/portal/portal.component';
import { MatButtonModule } from '@angular/material/button';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatDividerModule } from '@angular/material/divider';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatIconModule } from '@angular/material/icon';
import { MatInputModule } from '@angular/material/input';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { MatTooltipModule } from '@angular/material/tooltip';
import { PortalHeaderComponent } from './components/portal/portal-header/portal-header.component';
import { PortalMenuComponent } from './components/portal/portal-menu/portal-menu.component';
import { PortalMenuItemComponent } from './components/portal/portal-menu-item/portal-menu-item.component';
import { PortalMenuSectionComponent } from './components/portal/portal-menu-section/portal-menu-section.component';
import { PortalContentDirective } from './components/portal/portal-content.directive';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
import { AccommodationFilterComponent } from './components/accommodation-filter/accommodation-filter.component';
import { LoaderComponent } from './components/loader/loader.component';
import { DateInputComponent } from './components/date-input/date-input.component';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { FormsModule } from '@angular/forms';
import { MAT_DATE_LOCALE } from '@angular/material/core';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';

@NgModule({
  declarations: [
    PortalComponent,
    PortalHeaderComponent,
    PortalMenuComponent,
    PortalMenuItemComponent,
    PortalMenuSectionComponent,
    PortalContentDirective,
    AccommodationFilterComponent,
    LoaderComponent,
    DateInputComponent
  ],
  imports: [
    CommonModule,
    MatButtonModule,
    MatIconModule,
    MatDividerModule,
    FontAwesomeModule,
    MatProgressBarModule,
    MatFormFieldModule,
    MatInputModule,
    MatCheckboxModule,
    MatTooltipModule,
    MatDatepickerModule,
    FormsModule,
    MatProgressSpinnerModule
  ],
  exports: [
    PortalComponent,
    PortalMenuComponent,
    PortalMenuSectionComponent,
    PortalMenuItemComponent,
    PortalContentDirective,
    AccommodationFilterComponent,
    LoaderComponent,
    DateInputComponent
  ],
  providers: [
    {provide: MAT_DATE_LOCALE, useValue: 'en-GB'}
  ]
})
export class SharedModule { }
