import { BrowserModule } from '@angular/platform-browser';
import { NgModule, Injector } from '@angular/core';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';

import { AppComponent } from './app.component';
import { FinancialInterfaceSetupComponent } from './financial-interface-setup/financial-interface-setup.component';
import { MatTabsModule } from '@angular/material/tabs';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import {
  FinancialInterfaceNotificationComponent
} from './financial-interface-setup/financial-interface-notification/financial-interface-notification.component';
import {
  FinancialInterfaceLoadingComponent
} from './financial-interface-setup/financial-interface-loading/financial-interface-loading.component';
import { FinancialOptionInputComponent } from './financial-interface-setup/inputs/financial-option-input/financial-option-input.component';
import { RawInputComponent } from './financial-interface-setup/inputs/raw-input/raw-input.component';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { FormsModule } from '@angular/forms';
import { MatExpansionModule } from '@angular/material/expansion';
import { SelectInputComponent } from './financial-interface-setup/inputs/select-input/select-input.component';
import { MatSelectModule } from '@angular/material/select';
import { NumericOrTextInputComponent } from './financial-interface-setup/inputs/numeric-or-text-input/numeric-or-text-input.component';
import { CheckboxInputComponent } from './financial-interface-setup/inputs/checkbox-input/checkbox-input.component';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { CsvInputComponent } from './financial-interface-setup/inputs/csv-input/csv-input.component';
import { SequenceInputComponent } from './financial-interface-setup/inputs/sequence-input/sequence-input.component';
import { createCustomElement } from '@angular/elements';
import { ResrequestCommonModule } from 'resrequest-angular-common';


@NgModule({
  declarations: [
    AppComponent,
    FinancialInterfaceSetupComponent,
    FinancialInterfaceNotificationComponent,
    FinancialInterfaceLoadingComponent,
    FinancialOptionInputComponent,
    RawInputComponent,
    SelectInputComponent,
    NumericOrTextInputComponent,
    CheckboxInputComponent,
    CsvInputComponent,
    SequenceInputComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    MatTabsModule,
    MatButtonModule,
    MatIconModule,
    MatInputModule,
    MatFormFieldModule,
    FormsModule,
    MatExpansionModule,
    MatSelectModule,
    MatCheckboxModule,
    ResrequestCommonModule
  ],
  entryComponents: [
    FinancialInterfaceSetupComponent
  ],
  providers: [],
  bootstrap: []
})
export class AppModule {
  constructor(private injector: Injector) {}

  ngDoBootstrap() {
    const el = createCustomElement(FinancialInterfaceSetupComponent, { injector: this.injector });
    customElements.define('rr-financial-interface-setup', el);
  }
}
