import { Component, OnInit, HostBinding } from '@angular/core';
import { FinancialInterfaceSetupService } from '../service/financial-interface-setup.service';
import { FinancialInterfaceNotification } from './financial-interface-notification';
import { take } from 'rxjs/operators';
import { FinancialInterfaceNotificationType } from './financial-interface-notification-type';
import { BehaviorSubject } from 'rxjs';

@Component({
  selector: 'app-financial-interface-notification',
  templateUrl: './financial-interface-notification.component.html',
  styleUrls: ['./financial-interface-notification.component.scss']
})
export class FinancialInterfaceNotificationComponent implements OnInit {
  @HostBinding('style.background-color') backgroundColour: string;
  @HostBinding('style.border-color') borderColour: string;
  content$: BehaviorSubject<string>;

  constructor(public setupService: FinancialInterfaceSetupService) {
    this.backgroundColour = '';
    this.borderColour = '';
    this.content$ = new BehaviorSubject<string>('');
  }

  ngOnInit() {
    this.setupService.notification$.pipe(take(1))
      .subscribe(
        notification => this.onNotification(notification)
    );
  }

  onNotification(notification: FinancialInterfaceNotification) {
    if (notification) {
      switch (notification.type) {
        case FinancialInterfaceNotificationType.Success:
          this.backgroundColour = '#2f8c32eb';
          this.borderColour = '#24860d';
          break;
        case FinancialInterfaceNotificationType.Error:
          this.backgroundColour = '#c9252feb';
          this.borderColour = '#c9252f';
          break;
        default:
          break;
      }

      this.content$.next(notification.content);
    }
  }

  close() {
    this.setupService.clearNotification();
  }

}
