import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { FinancialOption } from '../../financial-option';
import { FinancialOptionInputComponent } from '../financial-option-input/financial-option-input.component';

@Component({
  selector: 'app-checkbox-input',
  templateUrl: './checkbox-input.component.html',
  styleUrls: ['./checkbox-input.component.scss'],
  providers: [{
    provide: FinancialOptionInputComponent,
    useExisting: forwardRef(() => CheckboxInputComponent)
  }]
})
export class CheckboxInputComponent implements OnInit {
  @Input() option: FinancialOption;
  value: boolean;

  constructor() { }

  ngOnInit() {
    if (this.option) {
      this.value = this.option.currentValue === '1';
    }
  }

  financialOption(): FinancialOption {
    if (this.option) {
      this.option.currentValue = this.value ? '1' : '0';
    }

    return this.option;
  }

}
