import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { FinancialOption } from '../../financial-option';
import { FinancialOptionInputComponent } from '../financial-option-input/financial-option-input.component';
import { InputValue } from '../input-value';

@Component({
  selector: 'app-csv-input',
  templateUrl: './csv-input.component.html',
  styleUrls: ['./csv-input.component.scss'],
  providers: [{
    provide: FinancialOptionInputComponent,
    useExisting: forwardRef(() => CsvInputComponent)
  }]
})
export class CsvInputComponent implements OnInit {
  @Input() option: FinancialOption;
  values: InputValue[];

  constructor() {
    this.values = [];
  }

  ngOnInit() {
    if (this.option) {
      if (this.option.currentValue === null) {
        this.option.currentValue = '';
      }

      this.values = this.option.currentValue.split(',').map((value: string) => {
        return new InputValue(value);
      });
    }
  }

  financialOption(): FinancialOption {
    if (this.option) {
      this.option.currentValue = this.values.map((value: InputValue) => {
        return value.value;
      }).join(',');
    }

    return this.option;
  }

  removeValue(index: number): void {
    this.values.splice(index, 1);
  }

  addValue(): void {
    this.values.push(new InputValue(''));
  }

}
