import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { FinancialOption } from '../../financial-option';
import { FinancialOptionInputComponent } from '../financial-option-input/financial-option-input.component';

@Component({
  selector: 'app-numeric-or-text-input',
  templateUrl: './numeric-or-text-input.component.html',
  styleUrls: ['./numeric-or-text-input.component.scss'],
  providers: [{
    provide: FinancialOptionInputComponent,
    useExisting: forwardRef(() => NumericOrTextInputComponent)
  }]
})
export class NumericOrTextInputComponent  extends FinancialOptionInputComponent implements OnInit {
  @Input() option: FinancialOption;
  @Input() type: 'text'|'number';
  value: string;

  constructor() {
    super();
    this.option = null;
    this.type = 'text';
    this.value = '';
  }

  ngOnInit() {
    if (this.option) {
      this.value = this.option.currentValue;

      if (!this.value) {
        this.value = this.option.defaultValue;
      }
    }
  }

  financialOption(): FinancialOption {
    if (this.option) {
      this.option.currentValue = this.value;
    }

    return this.option;
  }

}