import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { FinancialOption } from '../../financial-option';
import { FinancialOptionInputComponent } from '../financial-option-input/financial-option-input.component';

@Component({
  selector: 'app-raw-input',
  templateUrl: './raw-input.component.html',
  styleUrls: ['./raw-input.component.scss'],
})
export class RawInputComponent extends FinancialOptionInputComponent implements OnInit {
  @Input() option: FinancialOption;
  value: string;

  constructor() {
    super();
    this.option = null;
    this.value = '';
  }

  ngOnInit() {
    if (this.option) {
      this.value = this.option.currentValue;

      if (!this.value) {
        this.value = this.option.defaultValue;
      }
    }
  }

  financialOption(): FinancialOption {
    if (this.option) {
      this.option.currentValue = this.value;
    }

    return this.option;
  }

}
