import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { FinancialOption } from '../../financial-option';
import { FinancialOptionInputComponent } from '../financial-option-input/financial-option-input.component';

@Component({
  selector: 'app-select-input',
  templateUrl: './select-input.component.html',
  styleUrls: ['./select-input.component.scss'],
  providers: [{
    provide: FinancialOptionInputComponent,
    useExisting: forwardRef(() => SelectInputComponent)
  }]
})
export class SelectInputComponent implements OnInit {
  @Input() option: FinancialOption;
  value: string;

  constructor() {
    this.value = '';
  }

  ngOnInit() {
    if (this.option) {
      this.value = this.option.currentValue;

      if (!this.value) {
        this.value = this.option.defaultValue;
      }
    }
  }

  financialOption(): FinancialOption {
    if (this.option) {
      this.option.currentValue = this.value;
    }

    return this.option;
  }

}
