import { Component, OnInit, Input, HostBinding } from '@angular/core';
import { Page } from '../page';
import { SupernovaService } from '../supernova/supernova.service';
import { Observable } from 'rxjs';

@Component({
  selector: 'app-page',
  templateUrl: './page.component.html',
  styleUrls: ['./page.component.scss'],
  providers: [SupernovaService]
})
export class PageComponent implements OnInit {
  page$: Observable<Page>;
  loading$: Observable<boolean>;
  hasErrors$: Observable<boolean>;
  @HostBinding('style.background-color') @Input() pageBackground: string;
  @Input() widgetBackground: string;
  @Input() widgetForeground: string;
  @Input() principal: string;
  @Input() page: number;
  @Input() source: string;

  constructor(public supernovaService: SupernovaService) {
    this.page$ = supernovaService.page$;
    this.loading$ = supernovaService.loading$;
    this.hasErrors$ = supernovaService.hasErrors$;
    this.pageBackground = '#e9e9e9';
    this.widgetBackground = '#23272d';
    this.widgetForeground = '#fff';
    this.source = 'https://supernova.resrequest.com/api';
  }

  ngOnInit() {
    if (this.principal && this.page) {
      this.supernovaService.fetchPage(this.source, this.principal, this.page);
    }
  }
}
