import { Component, Input, ViewChild, ElementRef, AfterViewInit } from '@angular/core';
import { Widget } from '../widget';
import { SupernovaService } from '../supernova/supernova.service';

@Component({
  selector: 'app-resnova-container',
  templateUrl: './resnova-container.component.html',
  styleUrls: ['./resnova-container.component.scss']
})
export class ResnovaContainerComponent implements AfterViewInit {
  @Input() widget: Widget;
  @Input() enableFullScreen: boolean;
  @Input() widgetBackground: string;
  @Input() widgetForeground: string;
  @ViewChild('supernovaContainer', {static: false}) container: ElementRef;
  expanded: boolean;

  constructor(public supernovaService: SupernovaService) {
    this.expanded = true;
  }

  ngAfterViewInit() {
    this.embedWidget();
  }

  embedWidget(): void {
    if (this.widget.version.charAt(0) === '3') {
      const url = new URL(this.widget.url);
      const apiUrl = this.widget.url;
      const scriptUrl = url.protocol + '//' + url.hostname + '/resources/widget/resnova.js';
      const styleUrl = url.protocol + '//' + url.hostname + '/resources/widget/resnova.css';

      const link = document.createElement('link');
      link.setAttribute('href', styleUrl);
      link.setAttribute('rel', 'stylesheet');

      const script = document.createElement('script');
      script.setAttribute('src', scriptUrl);

      const app = document.createElement('rr-resnova');
      app.setAttribute('widget-id', this.widget.resnova_id);
      app.setAttribute('api-url', apiUrl);

      this.container.nativeElement.appendChild(link);
      this.container.nativeElement.appendChild(script);
      this.container.nativeElement.appendChild(app);
    } else {
      // Legacy
      const widget = document.createElement('div');
      widget.setAttribute('interfaceName', this.widget.name);
      widget.setAttribute('widgetVersion', this.widget.version);
      widget.setAttribute('class', `resrequest-widget resrequest-widget-${this.widget.resnova_id}`);
      this.container.nativeElement.appendChild(widget);
      const script = document.createElement('script');
      script.setAttribute('async', 'true');
      script.setAttribute('src', this.widget.url);
      this.container.nativeElement.appendChild(script);
    }
  }

  toggleFullscreen() {
    this.supernovaService.toggleFullScreen(this.widget);
  }

  toggleExpand() {
    this.expanded = !this.expanded;
  }
}
