/*
    ===========================================================================

    The contents of this file will be executed after the required tables
    for each database have been copied to the temporary working database,
    this occurs before the columns for the allowed tables are removed.

    ===========================================================================
*/

/* 
    Remove all pr_persona records that meet the following criteria:

    * Is not a property
    * Is not currently an originator on a reservation
    * Is not currently an agent on a reservation
 */

DELETE pr_persona
FROM pr_persona
LEFT JOIN rv_reservation reservation_agent ON pr_persona.pr_persona_ix = reservation_agent.rv_agent_id
LEFT JOIN rv_reservation reservation_originator ON pr_persona.pr_persona_ix = reservation_originator.rv_origin_agent_id
LEFT JOIN pr_business ON pr_persona.pr_persona_ix = pr_business.pr_business_id
WHERE 
    reservation_agent.rv_reservation_ix IS NULL
    AND reservation_originator.rv_reservation_ix IS NULL
    AND pr_business.pr_business_id IS NULL;

/*
    Remove audit trail entries that are not reservation status changes.
    This prevents guest names and other personal data from being extracted
*/

DELETE ad_reservation
FROM ad_reservation
WHERE ad_reservation.ad_res_form NOT LIKE "Reservation status:%"