<?php
$mimetypes = array(
	'css' => "text/css",
	'csv' => "text/csv",
	'htm' => "text/html",
	'html' => "text/html",
	'js' => "text/javascript",
	'yaml' => "text/yaml",
	'bmp' => "image/bmp",
	'gif' => "image/gif",
	'jpeg' => "image/jpeg",
	'jpg' => "image/jpeg",
	'ico' => "image/x-icon",
	'png' => "image/png",
	'svg' => "image/svg+xml",
	'tif' => "image/tiff",
	'tiff' => "image/tiff",
	'doc' => "application/msword",
	'docx' => "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	'json' => "application/json",
	'otf' => "application/x-font-otf",
	'pdf' => "application/pdf",
	'ppsx' => "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
	'ppt' => "application/vnd.ms-powerpoint",
	'pptx' => "application/vnd.openxmlformats-officedocument.presentationml.presentation",
	'sldx' => "application/vnd.openxmlformats-officedocument.presentationml.slide",
	'sxc' => "application/vnd.sun.xml.calc",
	'sxi' => "application/vnd.sun.xml.impress",
	'sxw' => "application/vnd.sun.xml.writer",
	'xlsx' => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
	'xml' => "application/xml",
	'zip' => "application/zip",
	'woff' => "font/woff",
	'woff2' => "font/woff2"
);
if (isset($_GET['action']) && $_GET['action'] == "resource") {
	$module = $_GET['module'];
	$path = $_GET['path'];
	if (!ctype_alnum($module))
		die("Module name must consist of only alphanumeric characters");

	$filetype = pathinfo($path, PATHINFO_EXTENSION);

	if (!isset($mimetypes[$filetype]))
		die(sprintf("Unrecognized file extension '%s'. Supported extensions: %s.", htmlspecialchars($filetype, ENT_QUOTES), implode(", ", array_keys($mimetypes))));

	$currentDir = realpath(".");

	if ($module === 'UI') {
		$filePath = realpath("module/Resrequest/UI/public/dist/{$path}");
	} else {
		$filePath = realpath("module/$module/public/$path") ? "module/$module/public/$path" :"module/$module/$path";
	}
	$destination = realpath($filePath);
	if (!$destination)
		die(sprintf("File not found: '%s'!", htmlspecialchars("$filePath", ENT_QUOTES)));

	if (substr($destination, 0, strlen($currentDir)) != $currentDir)
		die(sprintf("Access to '%s' is not allowed!", htmlspecialchars($destination, ENT_QUOTES)));

	header(sprintf("Content-type: %s", $mimetypes[$filetype]));
	readfile("$filePath", FALSE);
	die();
} elseif (isset($_GET['action']) && $_GET['action'] == "client_images") {
	$client = $_GET['client'];
	$path = $_GET['path'];

	if ($client != "shared" && !is_numeric($client)) {
		die("Client number must consist of only numeric characters");
	}
	$filetype = pathinfo($path, PATHINFO_EXTENSION);

	if (!isset($mimetypes[$filetype]))
		die(sprintf("Unrecognized file extension '%s'. Supported extensions: %s.", htmlspecialchars($filetype, ENT_QUOTES), implode(", ", array_keys($mimetypes))));

	$currentDir = realpath(".");
	$filePath = realpath("../images/$client/$path");
	$destination = realpath($filePath);
	if (!$destination || empty($filePath))
		die(sprintf("File not found: '%s'!", htmlspecialchars("$filePath", ENT_QUOTES)));

	header(sprintf("Content-type: %s", $mimetypes[$filetype]));
	readfile("$filePath", FALSE);
	die();
}

// handle static loading of PHP code where the session must not be started (eg. payment gateways)
if(array_key_exists("REQUEST_URI", $_SERVER) && substr($_SERVER['REQUEST_URI'], 0, 16) != "/reservation.php" && strpos($_SERVER['REQUEST_URI'], ".php") !== false) {
	$modules = array_filter(scandir("module"), function($filename) {
		if($filename != "." && $filename != ".." && is_dir("module/".$filename)) {
			return true;
		}
		return false;
	});
	$statics = [];
	foreach($modules as $module) {
		$config = "module/$module/config/static.config.php";
		if(file_exists($config)) {
			$statics[$module] = include($config);
		}
	}
	foreach($statics as $module=>$routes) {
		foreach($routes as $route=>$destination) {
			if(substr($_SERVER['REQUEST_URI'], 0, strlen($route)) == $route) {
				$filename = "module/" . $module . "/" . $destination . $route;
				if(file_exists($filename)) {
					require($filename);
					die();
				}
			}
		}
	}
}

