<?php
/**
 * This is the index.php from the zf2 skeleton application
 * it was renamed to index-zf2-wrapper.php since the
 * legacy application could have (and possibly already has) an index.php
 *
 * additionally it uses MaglLegacyApplication::run() to be able to access the ZF2 mvc application from
 * within your legacy application
 */

define('REQUEST_MICROTIME', microtime(true));
chdir(dirname(__DIR__));

// handle resource loading
require_once("include/inc.action.php");

// Decline static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server' && is_file(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH))) {
    return false;
}

// Setup autoloading
require 'init_autoloader.php';

$application = Zend\Mvc\Application::init(require 'config/application.config.php');
\MaglLegacyApplication\Application\MaglLegacy::getInstance()->setApplication($application);
$application->run();
