create
    definer = root@localhost procedure sp_flag_record_for_delete(IN tc_table_id int, IN record_id char(36))
flag_record_for_delete: BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE remote_db_code CHAR(2); 
    DECLARE remote_codes CURSOR FOR
    SELECT 
        rf_db_code
    FROM
        rf_database
    WHERE
        rf_db_code NOT LIKE "W%"
        AND rf_db_env_type_web_yn = 0
        AND rf_db_inactive_yn = 0;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;

    IF @is_env_web THEN
        OPEN remote_codes;
        REPEAT 
            FETCH remote_codes INTO remote_db_code;
            IF NOT ch_done THEN
                DELETE FROM tc_property_trf
                WHERE
                    rf_db_code = remote_db_code
                    AND tc_table_id = tc_table_id
                    AND tc_prop_record_id = record_id;

                DELETE FROM tc_property_trf_prc
                WHERE
                    rf_db_code = remote_db_code
                    AND tc_table_id = tc_table_id
                    AND tc_prop_record_id = record_id;

                INSERT IGNORE INTO td_prop_deletions (
                    rf_db_code,
                    tc_table_id,
                    td_record_id
                ) VALUES (
                    remote_db_code,
                    tc_table_id,
                    record_id
                );
            END IF;
        UNTIL ch_done END REPEAT;
        CLOSE remote_codes;
    ELSE
        INSERT INTO td_deletions (td_dlt_table_id, td_dlt_rec_id) VALUES (tc_table_id, record_id);
    END IF;
END;

