create
    definer = root@localhost procedure sp_flag_record_for_transfer(IN tc_table_id int, IN record_id varchar(36))
flag_record_for_transfer: BEGIN
    DECLARE ch_done TINYINT(1) DEFAULT FALSE;
    DECLARE remote_db_code CHAR(2); 
    DECLARE remote_codes CURSOR FOR
        SELECT 
            rf_db_code
        FROM
            rf_database
        WHERE
            rf_db_code NOT LIKE "W%"
            AND rf_db_env_type_web_yn = 0
            AND rf_db_inactive_yn = 0;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET ch_done = TRUE;

    IF @is_env_web THEN
        OPEN remote_codes;
        REPEAT
            FETCH remote_codes INTO remote_db_code;
            IF NOT ch_done THEN
                INSERT IGNORE INTO tc_property_trf
                    (rf_db_code, tc_table_id, tc_prop_record_id)
                VALUES (
                    remote_db_code,
                    tc_table_id,
                    record_id
                );
            END IF;
        UNTIL ch_done END REPEAT;
        CLOSE remote_codes;
    END IF;
END;

