create definer = root@localhost trigger tr_ml_period_upd_be
    before update
    on ml_period
    for each row
BEGIN
                        DECLARE row_transferred TINYINT(1); 

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();
                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "ml_period" INTO @tc_table_id;
                        SET row_transferred = OLD.ml_period_trf_yn;
                        IF row_transferred != 0 THEN
                            IF @is_env_master = 0 THEN
                                SIGNAL SQLSTATE "45000" SET
                                MYSQL_ERRNO = "30002",
                                MESSAGE_TEXT = "Cannot edit data transferred row on slave environment";
                            END IF;
                        END IF;
                        IF @transfer_flagging IS NOT FALSE THEN
                            CALL sp_flag_record_for_transfer(@tc_table_id, OLD.ml_period_ix);
                            IF @is_env_web IS FALSE THEN
                                SET NEW.ml_period_trf_yn = 0;
                            END IF;
                        END IF;

                        IF @is_env_web IS FALSE THEN
                            IF NEW.ml_period_trf_yn IS NULL THEN
                                SET NEW.ml_period_trf_yn = 0;
                            END IF;
                        END IF;
                    END;

