create definer = root@localhost trigger tr_pr_user_password_del_be
    before delete
    on pr_user_password
    for each row
BEGIN

                        DECLARE row_transferred TINYINT(1); 

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "pr_user_password" INTO @tc_table_id;
                            SELECT pr_user_password_trf_yn FROM pr_user_password WHERE pr_user_password_ix = OLD.pr_user_password_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.pr_user_password_ix);
                            END IF;

                            END;

