create definer = root@localhost trigger tr_rf_sys_admin_del_be
    before delete
    on rf_sys_admin
    for each row
BEGIN

                        DECLARE row_transferred TINYINT(1); 

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "rf_sys_admin" INTO @tc_table_id;
                            SELECT rf_sys_admin_trf_yn FROM rf_sys_admin WHERE rf_sys_admin_ix = OLD.rf_sys_admin_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rf_sys_admin_ix);
                            END IF;

                            END;

