create definer = root@localhost trigger tr_rv_res_item_special_del_be
    before delete
    on rv_res_item_special
    for each row
BEGIN

                        DECLARE row_transferred TINYINT(1); 

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "rv_res_item_special" INTO @tc_table_id;
                            SELECT rv_res_item_special_trf_yn FROM rv_res_item_special WHERE rv_res_item_special_ix = OLD.rv_res_item_special_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.rv_res_item_special_ix);
                            END IF;

                            END;

