create definer = root@localhost trigger tr_sc_env_group_del_be
    before delete
    on sc_env_group
    for each row
BEGIN

                        DECLARE row_transferred TINYINT(1); 

                        CALL sp_check_environment();
                        CALL sp_is_environment_master();
                        CALL sp_is_environment_web();

                        SELECT tc_table_id FROM tc_table WHERE tc_table_name = "sc_env_group" INTO @tc_table_id;
                            SELECT sc_env_group_trf_yn FROM sc_env_group WHERE sc_env_group_ix = OLD.sc_env_group_ix INTO row_transferred;

                            IF row_transferred != 0 THEN
                                IF @is_env_master = 0 THEN
                                    SIGNAL SQLSTATE "45000" SET
                                    MYSQL_ERRNO = "30002",
                                    MESSAGE_TEXT = "Cannot delete data transferred row on slave environment";
                                END IF;
                            END IF;

                            IF @transfer_flagging IS NOT FALSE THEN
                                CALL sp_flag_record_for_delete(@tc_table_id, OLD.sc_env_group_ix);
                            END IF;

                            END;

